/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite;

import icyllis.arc3d.core.ColorSpace;
import icyllis.arc3d.core.ImageInfo;
import icyllis.arc3d.core.Matrix;
import icyllis.arc3d.core.Matrixc;
import icyllis.arc3d.core.RawPtr;
import icyllis.arc3d.core.Rect2i;
import icyllis.arc3d.core.Rect2ic;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.ImageViewProxy;
import icyllis.arc3d.engine.RecordingContext;
import icyllis.arc3d.engine.task.ImageUploadTask;
import icyllis.arc3d.engine.task.Task;
import icyllis.arc3d.engine.task.TaskList;
import icyllis.arc3d.granite.Draw;
import icyllis.arc3d.granite.DrawOrder;
import icyllis.arc3d.granite.DrawPass;
import icyllis.arc3d.granite.DrawTask;
import icyllis.arc3d.granite.RenderPassTask;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public final class SurfaceDrawContext
implements AutoCloseable {
    private final ImageInfo mImageInfo;
    @SharedPtr
    private final ImageViewProxy mReadView;
    private final short mWriteSwizzle;
    private TaskList mDrawTaskList;
    private Matrix mLastTransform;
    private final ObjectArrayList<Draw> mPendingDraws = new ObjectArrayList();
    private int mNumSteps;
    private final ObjectArrayList<@SharedPtr ImageUploadTask> mPendingUploads = new ObjectArrayList();
    private byte mPendingLoadOp = 0;
    private byte mPendingStoreOp = 0;
    private final float[] mPendingClearColor = new float[4];

    private SurfaceDrawContext(@SharedPtr ImageViewProxy readView, short writeSwizzle, ImageInfo imageInfo) {
        this.mReadView = readView;
        this.mWriteSwizzle = writeSwizzle;
        this.mImageInfo = imageInfo;
        this.mDrawTaskList = new TaskList();
    }

    @Nullable
    public static SurfaceDrawContext make(RecordingContext context, @SharedPtr ImageViewProxy targetView, ImageInfo deviceInfo) {
        if (targetView == null) {
            return null;
        }
        if (context == null || context.isDiscarded()) {
            targetView.unref();
            return null;
        }
        if (deviceInfo.alphaType() != 1 && deviceInfo.alphaType() != 2) {
            targetView.unref();
            return null;
        }
        if (!targetView.getDesc().isRenderable()) {
            targetView.unref();
            return null;
        }
        assert (targetView.getWidth() >= deviceInfo.width() && targetView.getHeight() >= deviceInfo.height());
        short writeSwizzle = context.getCaps().getWriteSwizzle(targetView.getDesc(), deviceInfo.colorType());
        return new SurfaceDrawContext(targetView, writeSwizzle, deviceInfo);
    }

    @Override
    public void close() {
        this.mReadView.unref();
        this.mDrawTaskList.close();
        this.mPendingDraws.forEach(Draw::close);
        this.mPendingDraws.clear();
        this.mPendingUploads.forEach(RefCnt::unref);
        this.mPendingUploads.clear();
    }

    @RawPtr
    public ImageViewProxy getReadView() {
        return this.mReadView;
    }

    public ImageInfo getImageInfo() {
        return this.mImageInfo;
    }

    public int getColorType() {
        return this.mImageInfo.colorType();
    }

    public int getAlphaType() {
        return this.mImageInfo.alphaType();
    }

    public int getWidth() {
        return this.mReadView.getWidth();
    }

    public int getHeight() {
        return this.mReadView.getHeight();
    }

    public boolean isMipmapped() {
        return this.mReadView.isMipmapped();
    }

    public int getOrigin() {
        return this.mReadView.getOrigin();
    }

    public short getReadSwizzle() {
        return this.mReadView.getSwizzle();
    }

    public void clear(@Nullable float[] clearColor) {
        this.discard();
        this.mPendingLoadOp = 1;
        if (clearColor != null) {
            System.arraycopy(clearColor, 0, this.mPendingClearColor, 0, 4);
        } else {
            Arrays.fill(this.mPendingClearColor, 0.0f);
        }
    }

    public void discard() {
        this.mPendingDraws.forEach(Draw::close);
        this.mPendingDraws.clear();
        this.mNumSteps = 0;
        this.mPendingLoadOp = (byte)2;
    }

    public int numPendingSteps() {
        return this.mNumSteps;
    }

    public void recordDraw(Draw draw) {
        assert (!draw.mDrawBounds.isEmpty());
        assert (new Rect2i(0, 0, this.mImageInfo.width(), this.mImageInfo.height()).contains(draw.mScissorRect));
        assert ((draw.mRenderer.depthStencilFlags() & 2) == 0 || DrawOrder.getStencilIndex(draw.mDrawOrder) != 0);
        draw.mTransform = this.getStableTransform(draw.mTransform);
        this.mPendingDraws.add((Object)draw);
        this.mNumSteps += draw.mRenderer.numSteps();
    }

    public boolean recordUpload(RecordingContext context, @SharedPtr ImageViewProxy imageViewProxy, int srcColorType, int srcAlphaType, ColorSpace srcColorSpace, int dstColorType, int dstAlphaType, ColorSpace dstColorSpace, ImageUploadTask.MipLevel[] levels, Rect2ic dstRect, ImageUploadTask.UploadCondition condition) {
        assert (new Rect2i(0, 0, imageViewProxy.getWidth(), imageViewProxy.getHeight()).contains(dstRect));
        @SharedPtr ImageUploadTask uploadTask = ImageUploadTask.make(context, imageViewProxy, srcColorType, srcAlphaType, srcColorSpace, dstColorType, dstAlphaType, dstColorSpace, levels, dstRect, condition);
        if (uploadTask == null) {
            return false;
        }
        this.mPendingUploads.add((Object)uploadTask);
        return true;
    }

    public void recordDependency(@SharedPtr Task task) {
        assert (task != null);
        this.mDrawTaskList.appendTask(task);
    }

    public void flush(RecordingContext context) {
        if (!this.mPendingUploads.isEmpty()) {
            this.mDrawTaskList.appendTasks((List<? extends Task>)this.mPendingUploads);
            assert (this.mPendingUploads.isEmpty());
        }
        assert (this.mPendingDraws.isEmpty() == (this.mNumSteps == 0));
        if (this.mPendingDraws.isEmpty() && this.mPendingLoadOp != 1) {
            return;
        }
        DrawPass pass = DrawPass.make(context, this.mPendingDraws, this.mNumSteps, this.mReadView, this.mImageInfo);
        this.mPendingDraws.forEach(Draw::close);
        this.mPendingDraws.clear();
        this.mNumSteps = 0;
        if (pass != null) {
            RenderPassTask renderPassTask = RenderPassTask.make(context, pass, RefCnt.create(this.mReadView), null, this.mPendingLoadOp, this.mPendingStoreOp, this.mPendingClearColor);
            this.mDrawTaskList.appendTask(renderPassTask);
        }
        this.mPendingLoadOp = 0;
        this.mPendingStoreOp = 0;
    }

    @Nullable
    @SharedPtr
    public DrawTask snapDrawTask(RecordingContext context) {
        this.flush(context);
        if (this.mDrawTaskList.isEmpty()) {
            return null;
        }
        DrawTask task = new DrawTask(RefCnt.create(this.mReadView), this.mDrawTaskList);
        this.mDrawTaskList = new TaskList();
        return task;
    }

    private Matrixc getStableTransform(Matrixc transform) {
        Matrix last = this.mLastTransform;
        if (!transform.equals(last)) {
            Matrix copy;
            this.mLastTransform = copy = transform.clone();
            return copy;
        }
        return last;
    }
}

